#version 450 compatibility


#define IS_NETHER

out vec3 sceneData;

in vec2 texcoord;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Functions.inc"

#include "/lib/Head/Material.inc"

#include "/lib/Head/Mask.inc"

#include "/lib/Water/WaterRefraction.glsl"

#include "/lib/Surface/ReflectionFilter.glsl"

#include "/lib/Atmosphere/Fogs.glsl"

#include "/lib/Water/WaterFog.glsl"

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel 		= ivec2(gl_FragCoord.xy);

	vec4 gbuffer3 		= texelFetch(colortex3, texel, 0);

	//vec3 albedoRaw 		= texelFetch(colortex6, texel, 0).rgb;
	//vec3 albedo 		= SRGBtoLinear(albedoRaw);
	vec4 albedoT 		= vec4(UnpackUnorm2x8(gbuffer3.z), UnpackUnorm2x8(gbuffer3.w));

	//vec2 mcLightmapT = texelFetch(colortex2, texel, 0).rg;
	//GetBlocklightFalloff(mcLightmapT);

	vec3 normal 		= DecodeNormal(gbuffer3.xy);

	int materialIDT 	= int(texelFetch(colortex7, texel, 0).z * 255.0);
	TranslucentMask materialMaskT = CalculateMasksT(materialIDT);

	float depth 		= GetDepth(texel);
	depth += 0.38 * step(depth, 0.56);
	float depthT 		= GetDepthT(texel);

	vec3 viewPos 		= ScreenToViewSpace(vec3(texcoord, depthT));
	if (depthT < 1.0) {
		vec3 viewDir  		= normalize(viewPos);
		vec3 worldPos 		= mat3(gbufferModelViewInverse) * viewPos + gbufferModelViewInverse[3].xyz;

		vec2 refractCoord  = CalculateRefractCoord(materialMaskT, normal, worldPos, viewPos, depth, depthT);
		ivec2 refractTexel = ivec2(refractCoord * screenSize);

		sceneData 			= texelFetch(colortex4, refractTexel, 0).rgb;

		vec3 albedoRaw 		= texelFetch(colortex6, refractTexel, 0).rgb;
		vec3 albedo 		= SRGBtoLinear(albedoRaw);

		Material material 	= GetMaterialData(texelFetch(colortex0, refractTexel, 0).xy);

		//float materialID 	= floor(texture(colortex3, refractCoord).b * 255.0);
		//MaterialMask materialMask = CalculateMasks(materialID);
	/*
		if ((materialMaskT.water || materialMaskT.ice) && isEyeInWater < 0.5) {
			float skyLightmap = texelFetch(colortex7, refractTexel, 0).g;
			GetSkylightFalloff(skyLightmap);
			vec3 viewPos0 = ScreenToViewSpace(refractCoord, GetDepthT(refractTexel));
			vec3 viewPos1 = ScreenToViewSpace(refractCoord, refractDepth);
			vec3 worldDir0 = mat3(gbufferModelViewInverse) * normalize(viewPos0);
			float LdotV = dot(worldLightVector, worldDir0);
			WaterFog(sceneData, materialMaskT, skyLightmap, LdotV, distance(viewPos0, viewPos1));
		}
	*/

		if (materialMaskT.translucent) {
			float rDist = length(ScreenToViewSpace(vec3(refractCoord, GetDepth(refractTexel))));
			NetherFog(sceneData, rDist);
			if (materialMaskT.stainedGlass) TransparentAbsorption(sceneData, albedoT);
			else if (materialMaskT.ice) sceneData *= sqr(albedoT.rgb);

			vec4 reflectionData = texelFetch(colortex2, texel, 0);
			sceneData = sceneData * reflectionData.a + reflectionData.rgb;
		} else if (material.hasReflections) {
			vec4 reflectionData = texelFetch(colortex2, texel, 0);
			#ifdef REFLECTION_FILTER
				if (material.isRough) reflectionData.rgb = ReflectionFilter(texel, reflectionData, material.roughness, normal, viewDir, 1.0, NoiseRotated(BlueNoiseTemporal())).rgb;
			#endif
			sceneData += reflectionData.rgb * mix(vec3(1.0), albedo, material.isMetal);
		}
	} else {
		sceneData = texelFetch(colortex4, texel, 0).rgb;
	}

	//if (materialMask.basic) sceneData = albedo * 4.0;

	float fogDist = length(viewPos);

	if (isEyeInWater == 1) UnderwaterFog(sceneData, materialMaskT, -viewPos.z);

	if (!materialMaskT.translucent) NetherFog(sceneData, fogDist);

	CommonFog(sceneData, fogDist);

	#if DEBUG_NORMAL == 0
		sceneData = clamp16F(sceneData);
	#elif DEBUG_NORMAL == 1
		sceneData = normal;
	#else
		sceneData = mat3(gbufferModelViewInverse) * normal;
	#endif
}

/* DRAWBUFFERS:4 */
